package com.hero.objects.modifiers;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.Multipower;
import com.hero.objects.VariablePowerPool;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.ModifierDialog;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Linked extends Modifier {
	private static String xmlID = "LINKED";

	private double lesserValue;

	private long linkedToID;

	private double origBase;

	public Linked(Element root) {
		super(root, Linked.xmlID);
	}

	@Override
	public Linked clone() {
		Linked l = (Linked) super.clone();
		l.setSelectedOption(getSelectedOption());
		l.setLinkedToID(linkedToID);
		return l;
	}

	@Override
	public double getBaseCost() {
		GenericObject val = getValue();
		if (val == null) {
			return origBase;
		} else if (parent == null) {
			return origBase;
		}
		Linked holder = null;
		int index = 0;
		int count = -1;
		for (Modifier mod : parent.getAssignedModifiers()) {
			count++;
			if (mod.getXMLID().equals(getXMLID())) {
				holder = (Linked) mod;
				parent.getAssignedModifiers().remove(count);
				index = count;
				break;
			}
		}
		double ret = lesserValue;
		if (val.getActiveCost() >= parent.getActiveCost()) {
			ret = origBase;
		}
		if (holder != null) {
			parent.getAssignedModifiers().add(index, holder);
		}
		return ret;
	}

	@Override
	public String getColumn2Output() {
		String adderString = "";
		String ret = "";
		ret += getAlias();
		double val = getTotalValue();
		for (Adder ad : getAssignedAdders()) {
			if (adderString.length() > 0) {
				adderString += "; ";
			}
			adderString += ad.getAlias();
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			if (ret.trim().length() > 0) {
				ret += ":  ";
			}
			ret += getInput();
		}
		for (Modifier mod : getAssignedModifiers()) {
			ret += ", " + mod.getAlias();
		}
		ret += " (";
		GenericObject linked = getValue();
		ret += linked == null ? "???"
				: linked.getName().trim().length() > 0 ? linked.getName()
						: linked.getAlias();
		ret += "; ";
		if (getComments().trim().length() > 0) {
			ret += getComments() + "; ";
		}
		if (adderString.trim().length() > 0) {
			ret += adderString + "; ";
		}
		ret += getFraction(val) + ")";

		return ret;
	}

	@Override
	public ModifierDialog getDialog(GenericObject parent, boolean isNew) {
		this.parent = parent; // for later comparison...
		ArrayList<Adder> ops = getOptionVector(parent);
		setOptions(ops);
		ModifierDialog dialog = super.getDialog(parent, isNew);
		dialog.optionsLbl.setText("Linked To:");
		dialog.optionsCB.setEditable(false);
		int index = 0;
		int count = -1;
		for (Adder ob : ops) {
			count++;
			if (ob.getID() == linkedToID) {
				index = count;
				break;
			}
		}
		if ((index >= 0) && (index < dialog.optionsCB.getItemCount())) {
			dialog.optionsCB.setSelectedIndex(index);
		}
		return dialog;
	}

	private ArrayList<Adder> getOptionVector(GenericObject parent) {
		ArrayList<Adder> vec = new ArrayList<Adder>();
		ArrayList<Long> ids = new ArrayList<Long>();
		OUTER: for (GenericObject o : HeroDesigner.getActiveHero().getPowers()) {
			if ((parent.getParentList() != null)
					&& ((parent.getParentList() instanceof Multipower)
							|| (parent.getParentList() instanceof ElementalControl) || (parent
							.getParentList() instanceof VariablePowerPool))
					&& (o.getParentList() != null)
					&& ((o.getParentList() instanceof Multipower)
							|| (o.getParentList() instanceof ElementalControl) || (o
							.getParentList() instanceof VariablePowerPool))) {
				continue OUTER;
			}
			if (((parent instanceof Multipower)
					|| (parent instanceof ElementalControl) || (parent instanceof VariablePowerPool))
					&& (o.getParentList() != null)) {
				continue OUTER;
			}
			if ((parent.getParentList() != null)
					&& (parent.getParentList().getID() == o.getID())) {
				continue OUTER;
			}
			if ((parent.getMainPower() != null)
					&& (parent.getMainPower().getID() == o.getID())) {
				continue OUTER;
			}
			if (o instanceof com.hero.objects.List) {
				continue OUTER;
			}
			if (o.getID() == parent.getID()) {
				continue OUTER;
			}
			GenericObject mod = GenericObject.findObjectByID(o
					.getAssignedModifiers(), "LINKED");
			if ((mod != null) && (mod.getSelectedOption() != null)) {
				GenericObject subLink = mod;
				if (subLink.getSelectedOption().getID() == getID()) {
					continue OUTER;
				}
			}
			Adder a = new Adder();
			a.setDisplay(o.getAlias());
			if (o.getName().trim().length() > 0) {
				a.setDisplay(o.getName());
			}
			a.setBaseCost(o.getActiveCost());
			a.setXMLID(o.getXMLID());
			a.setID(o.getID());
			vec.add(a);
			ids.add(o.getID());
			if (o instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) o;
				INNER: for (GenericObject o2 : cp.getPowers()) {
					if (o2 instanceof com.hero.objects.List) {
						continue INNER;
					}
					if (o2.getID() == parent.getID()) {
						continue INNER;
					}
					GenericObject mod2 = GenericObject.findObjectByID(o2
							.getAssignedModifiers(), "LINKED");
					if ((mod2 != null) && (mod2.getSelectedOption() != null)) {
						GenericObject subLink = mod2;
						if (subLink.getSelectedOption().getID() == getID()) {
							continue INNER;
						}
					}
					Adder a2 = new Adder();
					a2.setDisplay(o2.getAlias());
					if (o2.getName().trim().length() > 0) {
						a2.setDisplay(o2.getName());
					}
					a2.setBaseCost(o2.getActiveCost());
					a2.setXMLID(o2.getXMLID());
					a2.setID(o2.getID());
					vec.add(a2);
					ids.add(o2.getID());
				}
			}
		}
		OUTER: for (GenericObject o : HeroDesigner.getActiveHero().getEquipment()) {
			if ((parent.getParentList() != null)
					&& ((parent.getParentList() instanceof Multipower)
							|| (parent.getParentList() instanceof ElementalControl) || (parent
							.getParentList() instanceof VariablePowerPool))
					&& (o.getParentList() != null)
					&& ((o.getParentList() instanceof Multipower)
							|| (o.getParentList() instanceof ElementalControl) || (o
							.getParentList() instanceof VariablePowerPool))) {
				continue OUTER;
			}
			if (((parent instanceof Multipower)
					|| (parent instanceof ElementalControl) || (parent instanceof VariablePowerPool))
					&& (o.getParentList() != null)) {
				continue OUTER;
			}
			if ((parent.getParentList() != null)
					&& (parent.getParentList().getID() == o.getID())) {
				continue OUTER;
			}
			if ((parent.getMainPower() != null)
					&& (parent.getMainPower().getID() == o.getID())) {
				continue OUTER;
			}
			if (o instanceof com.hero.objects.List) {
				continue OUTER;
			}
			if (o.getID() == parent.getID()) {
				continue OUTER;
			}
			GenericObject mod = GenericObject.findObjectByID(o
					.getAssignedModifiers(), "LINKED");
			if ((mod != null) && (mod.getSelectedOption() != null)) {
				GenericObject subLink = mod;
				if (subLink.getSelectedOption().getID() == getID()) {
					continue OUTER;
				}
			}
			Adder a = new Adder();
			a.setDisplay(o.getAlias());
			if (o.getName().trim().length() > 0) {
				a.setDisplay(o.getName());
			}
			a.setBaseCost(o.getActiveCost());
			a.setXMLID(o.getXMLID());
			a.setID(o.getID());
			vec.add(a);
			ids.add(o.getID());
			if (o instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) o;
				INNER: for (GenericObject o2 : cp.getPowers()) {
					if (o2 instanceof com.hero.objects.List) {
						continue INNER;
					}
					if (o2.getID() == parent.getID()) {
						continue INNER;
					}
					GenericObject mod2 = GenericObject.findObjectByID(o2
							.getAssignedModifiers(), "LINKED");
					if ((mod2 != null) && (mod2.getSelectedOption() != null)) {
						GenericObject subLink = mod2;
						if (subLink.getSelectedOption().getID() == getID()) {
							continue INNER;
						}
					}
					Adder a2 = new Adder();
					a2.setDisplay(o2.getAlias());
					if (o2.getName().trim().length() > 0) {
						a2.setDisplay(o2.getName());
					}
					a2.setBaseCost(o2.getActiveCost());
					a2.setXMLID(o2.getXMLID());
					a2.setID(o2.getID());
					vec.add(a2);
					ids.add(o2.getID());
				}
			}
		}
		if (parent.getMainPower() != null) {
			CompoundPower cp = parent.getMainPower();
			INNER: for (GenericObject o2 : cp.getPowers()) {
				if (o2 instanceof com.hero.objects.List) {
					continue INNER;
				}
				if (o2.getID() == parent.getID()) {
					continue INNER;
				}
				GenericObject mod2 = GenericObject.findObjectByID(o2
						.getAssignedModifiers(), "LINKED");
				if ((mod2 != null) && (mod2.getSelectedOption() != null)) {
					GenericObject subLink = mod2;
					if (subLink.getSelectedOption().getID() == getID()) {
						continue INNER;
					}
				}
				Adder a2 = new Adder();
				a2.setDisplay(o2.getAlias());
				if (o2.getName().trim().length() > 0) {
					a2.setDisplay(o2.getName());
				}
				a2.setBaseCost(o2.getActiveCost());
				a2.setXMLID(o2.getXMLID());
				a2.setID(o2.getID());
				if (!ids.contains(o2.getID())) {
					vec.add(a2);
					ids.add(o2.getID());
				}
			}
		}
		return vec;
	}

	@Override
	public Element getSaveXML() {
		Element root = super.getSaveXML();
		getValue(); // just for safety...make sure it's been set
		root.setAttribute("LINKED_ID", "" + linkedToID);
		return root;
	}

	@Override
	public double getTotalValue() {
		double val = getBaseCost();
		for (Adder ad : getAssignedAdders()) {
			val += ad.getDoubleTotal();
		}
		if (getLevelValue() > 0) {
			val += getLevels() / getLevelValue() * getLevelCost();
		}
		double advantageTotal = 0d;
		for (Modifier mod : getAssignedModifiers()) {
			if (mod.getTotalValue() > 0) {
				advantageTotal += mod.getTotalValue();
			}
		}
		double active = val * (1 + advantageTotal);
		double limitationTotal = 0d;
		for (Modifier mod : assignedModifiers) {
			if (mod.getTotalValue() < 0) {
				limitationTotal += Math.abs(mod.getTotalValue());
			}
		}
		val = active / (1 + limitationTotal);
		if ((val < getMinimumCost()) && isMinSet()) {
			return getMinimumCost();
		} else if ((val > getMaxCost()) && isMaxSet()) {
			return getMaxCost();
		} else {
			return val;
		}
	}

	/**
	 * Returns the object that the parent object is Linked to.
	 * 
	 * @return
	 */
	public GenericObject getValue() {
		if (HeroDesigner.getActiveHero() == null) {
			return null;
		}
		purifyLinkedObject();
		if (linkedToID < 0) {
			return null;
		}
		for (GenericObject o : HeroDesigner.getActiveHero().getPowers()) {
			if (o.getID() == linkedToID) {
				return o;
			} else if (o instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) o;
				for (GenericObject o2 : cp.getPowers()) {
					if (o2.getID() == linkedToID) {
						return o2;
					}
				}
			}
		}
		if ((parent != null) && (parent.getMainPower() != null)) {
			for (GenericObject o : parent.getMainPower().getPowers()) {
				if (o.getID() == linkedToID) {
					return o;
				}
			}
		}
		return null;
	}

	@Override
	public String included(GenericObject o) {
		String ret = super.included(o);
		if (ret.trim().length() > 0) {
			return ret;
		}

        if (forceAllow()) return ret;
		if (!o.isPower() && !(o instanceof Power)) {
			return getDisplay() + " can only be applied to Powers.";
		}
		if (getOptionVector(o).size() > 0) {
			return "";
		} else {
			return "There are no other abilities on the character that can be Linked to.";
		}
	}

	@Override
	protected void init(Element element) {
		super.init(element);
		lesserValue = -.25;
		origBase = baseCost;
		String check = XMLUtility.getValue(element, "LESSERVALUE");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				lesserValue = Double.parseDouble(check);
			} catch (NumberFormatException ex) {
			}
		}
	}

	@Override
	public boolean isLimitation() {
		return true;
	}

	private void purifyLinkedObject() {
		if (getProgenitor() != null) {
			if (((getProgenitor().getParentList() != null) && (getProgenitor()
					.getParentList().getID() == linkedToID))
					|| ((getProgenitor().getMainPower() != null) && (getProgenitor()
							.getMainPower().getID() == linkedToID))) {
				linkedToID = -1;
			}
		}
	}

	@Override
	public void restoreFromSave(Element root) {
		super.restoreFromSave(root);
		String check = XMLUtility.getValue(root, "LINKED_ID");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				linkedToID = Long.parseLong(check);
			} catch (NumberFormatException ex) {
			}
		} else {
			linkedToID = -1;
		}
	}

	/**
	 * Sets the object that the parent is Linked to. The Link is tracked by id.
	 * 
	 * @param val
	 */
	public void setLinkedToID(long val) {
		linkedToID = val;
	}

	@Override
	public void setSelectedOption(Adder option) {
		if ((option != null) && (option.getID() > 0)) {
			linkedToID = option.getID();
		} else {
			linkedToID = -1;
		}
		super.setSelectedOption(option);
		if (option == null) {
			return;
		}
		if (option.getBaseCost() > parent.getActiveCost()) {
			setBaseCost(origBase);
		} else {
			setBaseCost(lesserValue);
		}
	}
}